import mongoose from 'mongoose';

const classSchema = new mongoose.Schema({
  studentId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Student',
    required: true
  },
  teacherId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Teacher',
    required: true
  },
  subject: {
    type: String,
    enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic'],
    required: true
  },
  scheduledDate: {
    type: Date,
    required: true
  },
  duration: {
    type: Number,
    default: 60,
    required: true
  },
  timezone: {
    type: String,
    required: true
  },
  classType: {
    type: String,
    enum: ['regular', 'trial', 'makeup'],
    default: 'regular'
  },
  status: {
    type: String,
    enum: ['scheduled', 'ongoing', 'completed', 'cancelled', 'rescheduled'],
    default: 'scheduled'
  },
  recurringSchedule: {
    isRecurring: {
      type: Boolean,
      default: false
    },
    frequency: {
      type: String,
      enum: ['daily', 'weekly', 'custom'],
      default: null
    },
    customDates: [{
      type: Date
    }],
    weeklyDays: [{
      type: String,
      enum: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
    }],
    endDate: {
      type: Date,
      default: null
    }
  },
  meetingLink: {
    type: String,
    default: null
  },
  attendanceStatus: {
    studentAttended: {
      type: Boolean,
      default: null
    },
    teacherAttended: {
      type: Boolean,
      default: null
    }
  },
  classNotes: {
    type: String,
    default: null
  },
  homeworkAssigned: {
    type: String,
    default: null
  },
  rescheduledFrom: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Class',
    default: null
  },
  rescheduledTo: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Class',
    default: null
  }
}, {
  timestamps: true
});

export default mongoose.models.TeacherClass || mongoose.model('TeacherClass', classSchema);